/*
 * Decompiled with CFR 0.152.
 */
package com.rcx.materialis;

import com.rcx.materialis.block.LightResidueBlock;
import com.rcx.materialis.util.RuneModifierRecipe;
import com.rcx.materialis.util.SensorModifierRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import slimeknights.mantle.registration.object.FluidObject;
import slimeknights.mantle.registration.object.ItemObject;
import slimeknights.tconstruct.common.TinkerModule;
import slimeknights.tconstruct.common.registration.CastItemObject;
import slimeknights.tconstruct.common.registration.ItemDeferredRegisterExtension;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.item.ModifiableItem;
import slimeknights.tconstruct.library.tools.part.ToolPartItem;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.tools.TinkerToolParts;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.stats.HeadMaterialStats;

public class MaterialisResources {
    public static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FLUIDS, (String)"materialis");
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"materialis");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"materialis");
    protected static final ItemDeferredRegisterExtension ITEMS_EXTENDED = new ItemDeferredRegisterExtension("materialis");
    private static final Supplier<Item.Properties> TOOL_PROPS = () -> new Item.Properties().m_41491_(TinkerTools.TAB_TOOLS);
    private static final Item.Properties PARTS_PROPS = new Item.Properties().m_41491_(TinkerToolParts.TAB_TOOL_PARTS);
    public static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"materialis");
    public static final RegistryObject<RuneModifierRecipe.Serializer> runeModifierSerializer = RECIPE_SERIALIZERS.register("rune_modifier", RuneModifierRecipe.Serializer::new);
    public static final RegistryObject<SensorModifierRecipe.Serializer> sensorModifierSerializer = RECIPE_SERIALIZERS.register("sensor_modifier", SensorModifierRecipe.Serializer::new);
    public static List<FluidWithBlockNBucket> fluidList = new ArrayList<FluidWithBlockNBucket>();
    public static final FluidWithBlockNBucket FAIRY_FLUID = MaterialisResources.addFluid("molten_fairy", "Molten Fairy", 1050, 15, 3000, 6000);
    public static final FluidWithBlockNBucket REFINED_RADIANCE_FLUID = MaterialisResources.addFluid("molten_refined_radiance", "Liquified Radiance", 1600, 15, 3000, 6000);
    public static final FluidWithBlockNBucket SHADOW_STEEL_FLUID = MaterialisResources.addFluid("molten_shadow_steel", "Molten Shadow Steel", 1600, 0, 3000, 6000);
    public static final FluidWithBlockNBucket ARCANE_GOLD_FLUID = MaterialisResources.addFluid("molten_arcane_gold", "Molten Arcane Gold", 970, 13, 3000, 6000);
    public static final FluidWithBlockNBucket NEPTUNIUM_FLUID = MaterialisResources.addFluid("molten_neptunium", "Molten Neptunium", 1700, 13, 3000, 6000);
    public static final FluidWithBlockNBucket QUICKSILVER_FLUID = MaterialisResources.addFluid("molten_quicksilver", "Molten Quicksilver", 700, 12, 3000, 6000);
    public static final FluidWithBlockNBucket STARMETAL_FLUID = MaterialisResources.addFluid("molten_starmetal", "Molten Starmetal", 1050, 11, 3000, 6000);
    public static final FluidWithBlockNBucket PINK_SLIME_FLUID = MaterialisResources.addFluid("molten_pink_slime", "Molten Pink Slime Alloy", 1260, 12, 3000, 6000);
    public static final FluidWithBlockNBucket CLOGGRUM_FLUID = MaterialisResources.addFluid("molten_cloggrum", "Molten Cloggrum", 950, 12, 3000, 6000);
    public static final FluidWithBlockNBucket FROSTSTEEL_FLUID = MaterialisResources.addFluid("molten_froststeel", "Molten Froststeel", 1160, 12, 3000, 6000);
    public static final FluidWithBlockNBucket UTHERIUM_FLUID = MaterialisResources.addFluid("molten_utherium", "Molten Utherium", 1370, 12, 3000, 6000);
    public static final FluidWithBlockNBucket FORGOTTEN_FLUID = MaterialisResources.addFluid("molten_forgotten_metal", "Molten Forgotten Metal", 1530, 12, 3000, 6000);
    public static final FluidWithBlockNBucket REGALIUM_FLUID = MaterialisResources.addFluid("molten_regalium", "Molten Regalium", 920, 12, 3000, 6000);
    public static final FluidWithBlockNBucket PSIMETAL_FLUID = MaterialisResources.addFluid("molten_psimetal", "Molten Psimetal", 1050, 12, 3000, 6000);
    public static final FluidWithBlockNBucket EBONY_PSIMETAL_FLUID = MaterialisResources.addFluid("molten_ebony_psimetal", "Molten Ebony Psimetal", 1430, 12, 3000, 6000);
    public static final FluidWithBlockNBucket IVORY_PSIMETAL_FLUID = MaterialisResources.addFluid("molten_ivory_psimetal", "Molten Ivory Psimetal", 1430, 12, 3000, 6000);
    public static final FluidWithBlockNBucket IESNIUM_FLUID = MaterialisResources.addFluid("molten_iesnium", "Molten Iesnium", 1390, 12, 3000, 6000);
    public static final FluidWithBlockNBucket MANASTEEL_FLUID = MaterialisResources.addFluid("molten_manasteel", "Molten Manasteel", 1090, 12, 3000, 6000);
    public static final FluidWithBlockNBucket ELEMENTIUM_FLUID = MaterialisResources.addFluid("molten_elementium", "Molten Elementium", 1460, 12, 3000, 6000);
    public static final FluidWithBlockNBucket TERRASTEEL_FLUID = MaterialisResources.addFluid("molten_terrasteel", "Molten Terrasteel", 1580, 12, 3000, 6000);
    public static final FluidWithBlockNBucket ALFSTEEL_FLUID = MaterialisResources.addFluid("molten_alfsteel", "Molten Alfsteel", 1740, 12, 3000, 6000);
    public static final FluidWithBlockNBucket DRACONIUM_FLUID = MaterialisResources.addFluid("molten_draconium", "Molten Draconium", 1350, 12, 3000, 6000);
    public static final FluidWithBlockNBucket AWAKENED_DRACONIUM_FLUID = MaterialisResources.addFluid("molten_draconium_awakened", "Molten Awakened Draconium", 1770, 12, 3000, 6000);
    public static final FluidWithBlockNBucket FLUX_INFUSED_FLUID = MaterialisResources.addFluid("molten_flux_infused", "Molten Flux-Infused Metal", 1180, 12, 3000, 6000);
    public static final RegistryObject<Block> LIGHT_RESIDUE = BLOCKS.register("light_residue", () -> new LightResidueBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76296_, (MaterialColor)MaterialColor.f_76398_).m_60913_(0.0f, 0.0f).m_60953_(state -> 15).m_60977_().m_60996_().m_60910_().m_60993_()));
    private static final Item.Properties SMELTERY_PROPS = new Item.Properties().m_41491_(TinkerSmeltery.TAB_SMELTERY);
    public static final CastItemObject INLAY_CAST = ITEMS_EXTENDED.registerCast("inlay", SMELTERY_PROPS);
    public static final CastItemObject WRENCH_HEAD_CAST = ITEMS_EXTENDED.registerCast("wrench_head", SMELTERY_PROPS);
    public static final ItemObject<ToolPartItem> WRENCH_HEAD = ITEMS_EXTENDED.register("wrench_head", () -> new ToolPartItem(PARTS_PROPS, HeadMaterialStats.ID));
    public static final ToolDefinition WRENCH_DEFINITION = ToolDefinition.builder((ResourceLocation)new ResourceLocation("materialis", "wrench")).meleeHarvest().build();
    public static final ItemObject<ModifiableItem> WRENCH = ITEMS_EXTENDED.register("wrench", () -> new ModifiableItem(TOOL_PROPS.get(), WRENCH_DEFINITION));
    public static final ToolDefinition BATTLEWRENCH_DEFINITION = ToolDefinition.builder((ResourceLocation)new ResourceLocation("materialis", "battlewrench")).meleeHarvest().build();
    public static final ItemObject<ModifiableItem> BATTLEWRENCH = ITEMS_EXTENDED.register("battlewrench", () -> new ModifiableItem(new Item.Properties(), BATTLEWRENCH_DEFINITION));
    public static final SlotType SENSOR_SLOT = SlotType.create((String)"sensor", (int)-1359318);
    public static List<IngotWithBlockNNugget> materialList = new ArrayList<IngotWithBlockNNugget>();
    public static final IngotWithBlockNNugget FAIRY_INGOT = MaterialisResources.addIngot("fairy", "Fairy", MaterialColor.f_76418_, 1, 6.0f, 6.0f);

    public static FluidWithBlockNBucket addFluid(String name, String localizedName, int temperature, int light, int density, int viscosity) {
        FluidWithBlockNBucket fluid = new FluidWithBlockNBucket(name, localizedName, temperature, light, density, viscosity);
        fluidList.add(fluid);
        return fluid;
    }

    public static IngotWithBlockNNugget addIngot(String name, String localizedName, MaterialColor color, int miningLevel, float hardness, float explosionResistance) {
        IngotWithBlockNNugget ingot = new IngotWithBlockNNugget(name, localizedName, color, miningLevel, hardness, explosionResistance);
        materialList.add(ingot);
        return ingot;
    }

    public static class FluidWithBlockNBucket {
        public final ForgeFlowingFluid.Properties PROPERTIES;
        public final RegistryObject<ForgeFlowingFluid.Source> FLUID;
        public final RegistryObject<ForgeFlowingFluid.Flowing> FLUID_FLOW;
        public final FluidObject<ForgeFlowingFluid> OBJECT;
        public final ResourceLocation TEXTURE_STILL;
        public final ResourceLocation TEXTURE_FLOW;
        public final RegistryObject<LiquidBlock> FLUID_BLOCK;
        public final RegistryObject<BucketItem> FLUID_BUCKET;
        public final String name;
        public final String localizedName;
        public final int temperature;
        public final int light;
        public final int density;
        public final int viscosity;

        public FluidWithBlockNBucket(String name, String localizedName, int temperature, int light, int density, int viscosity) {
            this.name = name;
            this.localizedName = localizedName;
            this.temperature = temperature;
            this.light = light;
            this.density = density;
            this.viscosity = viscosity;
            this.FLUID = FLUIDS.register(name, () -> new ForgeFlowingFluid.Source(this.getFluidProperties()));
            this.FLUID_FLOW = FLUIDS.register("flowing_" + name, () -> new ForgeFlowingFluid.Flowing(this.getFluidProperties()));
            this.TEXTURE_STILL = new ResourceLocation("materialis", "block/fluid/" + name + "_still");
            this.TEXTURE_FLOW = new ResourceLocation("materialis", "block/fluid/" + name + "_flow");
            this.PROPERTIES = new ForgeFlowingFluid.Properties(this.FLUID, this.FLUID_FLOW, FluidAttributes.builder((ResourceLocation)this.TEXTURE_STILL, (ResourceLocation)this.TEXTURE_FLOW).overlay(this.TEXTURE_STILL).luminosity(light).density(density).viscosity(6000).temperature(temperature).sound(SoundEvents.f_11783_, SoundEvents.f_11780_));
            this.FLUID_BLOCK = BLOCKS.register(name + "_block", () -> new LiquidBlock(this.FLUID, BlockBehaviour.Properties.m_60939_((Material)Material.f_76307_).m_60953_(state -> light).m_60977_().m_60978_(100.0f).m_60993_()));
            this.FLUID_BUCKET = ITEMS.register(name + "_bucket", () -> new BucketItem(this.FLUID, new Item.Properties().m_41495_(Items.f_42446_).m_41487_(1).m_41491_(CreativeModeTab.f_40753_)));
            this.PROPERTIES.bucket(this.FLUID_BUCKET).block(this.FLUID_BLOCK).explosionResistance(1000.0f).tickRate(9);
            this.OBJECT = new FluidObject(new ResourceLocation("materialis", name), name, this.FLUID, this.FLUID_FLOW, this.FLUID_BLOCK);
        }

        public ForgeFlowingFluid.Properties getFluidProperties() {
            return this.PROPERTIES;
        }
    }

    public static class IngotWithBlockNNugget {
        public final String name;
        public final String localizedName;
        public final RegistryObject<Block> BLOCK;
        public final RegistryObject<Item> INGOT;
        public final RegistryObject<Item> NUGGET;
        public final RegistryObject<BlockItem> BLOCK_ITEM;

        public IngotWithBlockNNugget(String name, String localizedName, MaterialColor color, int miningLevel, float hardness, float explosionResistance) {
            this.name = name;
            this.localizedName = localizedName;
            this.BLOCK = BLOCKS.register(name + "_block", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)color).m_60913_(hardness, explosionResistance).m_60918_(SoundType.f_56743_).m_60999_()));
            this.INGOT = ITEMS.register(name + "_ingot", () -> new Item(new Item.Properties().m_41491_(TinkerModule.TAB_GENERAL)));
            this.NUGGET = ITEMS.register(name + "_nugget", () -> new Item(new Item.Properties().m_41491_(TinkerModule.TAB_GENERAL)));
            this.BLOCK_ITEM = ITEMS.register(name + "_block", () -> new BlockItem((Block)this.BLOCK.get(), new Item.Properties().m_41491_(TinkerModule.TAB_GENERAL)));
        }
    }
}

